(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     42097,       1254]*)
(*NotebookOutlinePosition[     43592,       1297]*)
(*  CellTagsIndexPosition[     43548,       1293]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Gradiente, divergencia, rotacional, laplaciano.", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada
\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "Como esta es la segunda pr\[AAcute]ctica de este curso debes volver a leer \
con atenci\[OAcute]n las normas para entregar los trabajos de \
pr\[AAcute]cticas que est\[AAcute]n escritas en la introducci\[OAcute]n de la \
pr\[AAcute]ctica primera. As\[IAcute]mismo, te recuerdo que el trabajo de pr\
\[AAcute]cticas debe ser un trabajo personal. Debes ser capaz de explicar con \
detalle el trabajo que has hecho en cualquiera de las pr\[AAcute]cticas que \
hayas entregado. No debes concederte la debilidad de copiar el trabajo \
realizado por otro compa\[NTilde]ero. Los intentos de disfrazar el \
c\[OAcute]digo cambiando nombres de variables, modificando los comentarios o \
alterando el orden son muy f\[AAcute]ciles de descubrir. En el caso de que \
las pr\[AAcute]cticas de dos alumnos se \"parezcan demasiado\" ambas ser\
\[AAcute]n calificadas ",
  StyleBox["como se merecen",
    FontSlant->"Italic"],
  ".\nCada pr\[AAcute]ctica se califica de 0 a 10. En la calificaci\[OAcute]n \
se tiene en cuenta no solamente la correcci\[OAcute]n de las soluciones dadas \
sino tambi\[EAcute]n la claridad de las explicaciones, la \"eficacia\" de los \
comandos definidos (por ejemplo, los comandos que definas para hacer c\
\[AAcute]lculos num\[EAcute]ricos deben trabajar num\[EAcute]ricamente), el \
control de la precisi\[OAcute]n de los resultados obtenidos (cuando ello \
tenga sentido) y, en general, todo lo que hace que la soluci\[OAcute]n \
propuesta sea m\[AAcute]s o menos eficiente, sencilla y elegante.\nEn esta pr\
\[AAcute]ctica vamos a estudiar los operadores diferenciales m\[AAcute]s \
importantes del c\[AAcute]lculo diferencial vectorial as\[IAcute] como \
algunas de las relaciones m\[AAcute]s \[UAcute]tiles que hay entre ellos."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gradiente de un campo escalar", "Section"],

Cell[TextData[{
  "El gradiente de un campo escalar ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es el campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]f\)]],
  " cuyas componentes son las derivadas parciales de primer orden de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". El vector gradiente es \[UAcute]til para calcular derivadas de un campo \
escalar en una direcci\[OAcute]n dada. Si ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es un campo escalar con derivadas parciales continuas, la derivada de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en un punto ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "en la direcci\[OAcute]n dada por el vector ",
  StyleBox["u ",
    FontSlant->"Italic"],
  "viene dada por el producto escalar ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]\[Del]\(f(a)\) | u\[RightAngleBracket]\)]],
  ". ",
  StyleBox[
  "El gradiente indica la direcci\[OAcute]n en la que el campo aumenta o \
disminuya m\[AAcute]s r\[AAcute]pidamente",
    FontWeight->"Bold"],
  ". Te recuerdo que una direcci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " es un vector de norma 1. Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(a)\) \[NotEqual] 0\)]],
  ", la direcci\[OAcute]n en la cual la derivada direccional de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "es m\[AAcute]xima, que indica la direcci\[OAcute]n en la cual el campo en \
",
  StyleBox["a ",
    FontSlant->"Italic"],
  "crece m\[AAcute]s r\[AAcute]pidamente, viene dada por el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(a)\) / || \[Del]\(f(a)\) || \)]],
  ". An\[AAcute]logamente, la direcci\[OAcute]n en la cual la derivada \
direccional de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "es m\[IAcute]nima, que indica la direcci\[OAcute]n en la cual el campo en \
",
  StyleBox["a ",
    FontSlant->"Italic"],
  "decrece m\[AAcute]s r\[AAcute]pidamente, viene dada por el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Del]\(f(a)\)\) / || \[Del]\(f(a)\) || \)]],
  ". Si ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "y ",
  StyleBox["b ",
    FontSlant->"Italic"],
  "son puntos de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "la direcci\[OAcute]n del punto ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "hacia el punto ",
  StyleBox["b ",
    FontSlant->"Italic"],
  "viene dada por el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((b - a)\) / || b - a || \)]],
  ".\nEn lo que sigue trabajaremos con campos escalares de dos o de tres \
variables. Aunque ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de comandos para calcular el vector gradiente de un campo escalar \
no vamos a usarlos en esta pr\[AAcute]ctica."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Define comandos que calculen el vector gradiente de un campo escalar de \
dos o de tres variables. La sintaxis del comando debe ser como sigue: \
grad[func][x,y] o grad[func][x,y,z] donde \"func\" es el nombre de la funci\
\[OAcute]n (que debe ser una variable del comando). \nCalcula las derivadas \
de las siguientes funciones en el punto y en la direcci\[OAcute]n que se \
indican en cada caso.\na) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 1\/\(1 + 2  x\^2 + 2  y\^2\)\)]],
  ", punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((2, 1)\)\)]],
  ", direcci\[OAcute]n hacia el origen.\nb) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2/4 + y\^2/9\)]],
  ", punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\), 1)\)\)]],
  ", direcci\[OAcute]n hacia el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((2, 1)\)\)]],
  ".\nc) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 4 - \((x - 2)\)\^2 - \((y - 3)\)\^2\)]],
  ", punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((2, 3)\)\)]],
  ", direcci\[OAcute]n hacia el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-2\), \(-3\))\)\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", " ", 
          FormBox[\(sen(\@\( .01 + x\^2 + y\^2\))\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, \(-2\))\)\)]],
  ", direcci\[OAcute]n hacia el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-2\), \(-1\))\)\)]],
  ".\ne)",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(f(x, y, z) = 
        x\^2 + 2  y\^2 + 3  z\^2 - 3\)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\) = \((1, \(-2\), 3)\)\)]],
  ", direcci\[OAcute]n hacia el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((3, \(-2\), 1)\)\)]],
  ".\nRepresenta los campos de gradiente de las funciones anteriores en la \
regi\[OAcute]n que se indica en cada caso. Para ello carga el paquete gr\
\[AAcute]fico \"PlotField\" y usa el comando \"PlotGradientField[ ]\" con la \
opci\[OAcute]n \"Axes\[Rule]True\". Consulta la ayuda de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " Debes explicar en cada caso, teniendo en cuenta c\[OAcute]mo es la funci\
\[OAcute]n correspondiente, por qu\[EAcute] el campo de gradientes tiene el \
aspecto que tiene. Para ello puede ser \[UAcute]til representar \
gr\[AAcute]ficamente las funciones.\na1) Campo de gradiente de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 1\/\(1 + 2  x\^2 + 2  y\^2\)\)]],
  " en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] x \[LessEqual] 
        1, \ \(-1\) \[LessEqual] y \[LessEqual] 1\)]],
  ".\nb1) Campo de gradiente de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2/4 + y\^2/9\)]],
  " en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] x \[LessEqual] 
        1, \ \(-1\) \[LessEqual] y \[LessEqual] 1\)]],
  ".\nc1) Campo de gradiente de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 4 - \((x - 2)\)\^2 - \((y - 3)\)\^2\)]],
  " en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`1.5 \[LessEqual] x \[LessEqual] 2.5, \ 
      2.5 \[LessEqual] y \[LessEqual] 3.5\)]],
  ".\nd1) Campo de gradiente de ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", " ", 
          FormBox[\(sen(\@\( .01 + x\^2 + y\^2\))\),
            "TraditionalForm"]}], TraditionalForm]]],
  " en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\) \[LessEqual] x \[LessEqual] 
        2, \ \(-2\) \[LessEqual] y \[LessEqual] 2\)]],
  ". Usa en este caso la opci\[OAcute]n \"ScaleFactor\[Rule]None\"."
}], "ExerciseText"],

Cell[BoxData[
    \(<< Graphics`PlotField`\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"PlotGradientField", "[", " ", 
        RowBox[{
          FormBox[\(Sin[\@\( .01 + x\^2 + y\^2\)]\),
            "TraditionalForm"], ",", \({x, \(-2\), 2}\), 
          ",", \({y, \(-2\), 2}\), ",", \(ScaleFactor \[Rule] None\)}], "]"}],
       ";"}]], "Input"],

Cell[BoxData[{
    \(\(\(grad[f_]\)[{x_, y_}] = {D[f[x, y], x], 
          D[f[x, y], y]};\)\), "\[IndentingNewLine]", 
    \(\(\(grad[f_]\)[{x_, y_, z_}] = {D[f[x, y, z], x], D[f[x, y, z], y], 
          D[f[x, y, z], z]};\)\), "\[IndentingNewLine]", 
    \(\(\(derivdir[f_]\)[a_, 
          u_] := \(grad[f]\)[
              a] . \((u - a)\)/\@\(\((u - a)\) . \((u - a)\)\);\)\)}], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_] = 
        1\/\(1 + 2  x\^2 + 2  y\^2\);\)\), "\[IndentingNewLine]", 
    \(\(derivdir[f]\)[{2, 1}, {0, 0}]\)}], "Input"],

Cell[BoxData[{
    \(\(\(grad[f_]\)[x_List] := 
        Module[{var, n}, n = Length[x]; 
          var = Table[
              z[k], {k, 1, 
                n}]; \[IndentingNewLine]\((\((Outer[D, {f @@ var}, var])\) /. 
                Table[z[k] \[Rule] x[\([k]\)], {k, 1, 
                    n}])\)[\([1]\)]];\)\), "\[IndentingNewLine]", 
    \(\(grad[f_]\)[x__] := \(grad[f]\)[{x}]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Supongamos que la temperatura en cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " del plano viene dada por la funci\[OAcute]n  "
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`T \((x, y)\) = 
      100\/\(1 + \((x - 10.5)\)\^2 + 2 \((y - 8.5)\)\^2\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Un misil parte de un punto inicial ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " y sigue una trayectoria poligonal formada por segmentos de longitud fija, \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta] > 0\)]],
  ", de manera que en cada v\[EAcute]rtice de la poligonal la \
direcci\[OAcute]n del misil es la de mayor aumento de la temperatura. Define \
una funci\[OAcute]n cuyas variables sean el punto inicial, la longitud de \
cada segmento (\[Delta]) y el n\[UAcute]mero de segmentos que forman la \
trayectoria. La salida de tu funci\[OAcute]n debe ser una gr\[AAcute]fica con \
la trayectoria seguida por el misil (que para \[Delta] peque\[NTilde]o \
parecer\[AAcute] una curva suave y no una poligonal). Esta gr\[AAcute]fica \
debe incluir el punto de salida en azul y el punto m\[AAcute]s caliente ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((10.5, 8.5)\)\(\ \)\)\)]],
  " en rojo con tama\[NTilde]o adecuado. Comprobar\[AAcute]s que la \
trayectoria se acerca (y quiz\[AAcute]s rodea) al punto m\[AAcute]s caliente. \
Experimenta con valores para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta] = 0.05, 0.1, 0.5, 1\)]],
  " y elige en cada caso un n\[UAcute]mero de segmentos y un punto inicial \
apropiados.\nOpcional: \na)Puedes destacar los v\[EAcute]rtices de la \
poligonal en color y tama\[NTilde]o adecuado (aparecer\[AAcute]n todos juntos \
para \[Delta] peque\[NTilde]o).\nb) Puedes controlar en la salida \
gr\[AAcute]fica los rangos de representaci\[OAcute]n, tanto en el eje de \
abscisas como en el de ordenadas, haci\[EAcute]ndolos depender del punto \
inicial (PlotRange\[Rule]{{xmin,xmax},{ymin,ymax}})."
}], "ExerciseText"],

Cell[BoxData[
    \(\(trayectoriamascaliente[inicio_, salto_, etapas_] := 
        Module[{siguiente, T, gradtemp, punto, puntosalida, puntollegada, 
            vertices}, \n
          T[x_, y_] = 100\/\(1 + \((x - 10.5)\)\^2 + 2 \((y - 8.5)\)\^2\); 
          puntosalida = 
            Graphics[{Hue[ .65], PointSize[ .04], 
                Point[inicio]}]; \[IndentingNewLine]puntollegada = 
            Graphics[{Hue[0], PointSize[ .04], Point[{10.5, 8.5}]}]; \n
          gradtemp[x_, y_] = {D[T[x, y], x], D[T[x, y], y]}; \n
          siguiente[{x_, y_}] = {x, y} + 
              salto*\ gradtemp[x, y]/\@N[gradtemp[x, y] . gradtemp[x, y]]; \n
          punto[0] = inicio; \n
          punto[k_] := \(punto[k] = 
              N[siguiente[punto[k - 1]]]\); \[IndentingNewLine]vertices = 
            Table[punto[k], {k, 0, etapas}]; \n
          poligonal = 
            Graphics[{Thickness[0.007], 
                Line[vertices], {Hue[ .3], PointSize[ .017], 
                  Point /@ vertices}}]; \n
          Show[puntosalida, poligonal, puntollegada, Axes \[Rule] Automatic, 
            AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
            AspectRatio \[Rule] Automatic, 
            PlotRange \[Rule] {{Min[{inicio[\([1]\)], 10.5}] - 1, 
                  Max[{inicio[\([1]\)], 10.5}] + 
                    1}, {Min[{inicio[\([2]\)], 8.5}] - 1, 
                  Max[{inicio[\([2]\)], 8.5}] + 1}}];];\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(trayectoriamascaliente[{16, \(-2\)}, 1, 20]\)], "Input"],

Cell[BoxData[
    \(trayectoriamascaliente[{0, \(-2\)}, 1, 20]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Supongamos que la temperatura en cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " del plano viene dada por la funci\[OAcute]n  "
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`T \((x, y)\) = 10 + x\^2 - y\^2\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Calcula el camino que seguir\[AAcute] una bacteria que en todo instante \
busca el mayor aumento de la temperatura y que parte de un punto inicial ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-2\), 1)\)\)]],
  ". \nSugerencias. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " el camino seguido por la bacteria. La direcci\[OAcute]n de dicho camino \
en todo punto debe ser la de mayor incremento de la temperatura. Eso da lugar \
a un par de ecuaciones diferenciales muy sencillas con condiciones iniciales \
",
  Cell[BoxData[
      \(TraditionalForm\`x \((0)\) = \(-2\), \ y \((0)\) = 1\)]],
  ". Usa el comando \"DSolve[ ]\" para resolverlas y representa \
gr\[AAcute]ficamente la soluci\[OAcute]n obtenida (consulta, si es preciso, \
la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")",
  "."
}], "ExerciseText"],

Cell[BoxData[{
    \(\(f[x_, y_] = 10 + x\^2 - y\^2;\)\), "\n", 
    \(\({u[t_], 
          v[t_]} = {D[f[x, y], x], D[f[x, y], y]} /. {x \[Rule] x[t], 
            y \[Rule] y[t]};\)\), "\n", 
    \(\[Gamma][
        t_] = {x[t], 
          y[t]} /. \((\(DSolve[{\(x'\)[t] \[Equal] u[t], \(y'\)[t] \[Equal] 
                    v[t], x[0] \[Equal] \(-2\), y[0] \[Equal] 1}, {x[t], 
                  y[t]}, t]\)[\([1]\)] // Simplify)\)\), "\n", 
    \(\(ParametricPlot[\[Gamma][t], {t, 0, 1}];\)\), "\n", 
    \(Clear[x, y, \[Gamma], f, u, v]\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Divergencia de un campo vectorial", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Define comandos que calculen la divergencia de un campo vectorial de dos o \
de tres variables. La sintaxis del comando debe ser como sigue: \
div[func][x,y] o div[func][x,y,z] donde \"func\" es el nombre de la funci\
\[OAcute]n (que debe ser una variable del comando). \nCalcula la divergencia \
de los siguientes campos vectoriales en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " que se indica en cada caso.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", 
          RowBox[{\(Exp[x]\), 
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(Cos[y]\), " ", 
                  StyleBox["i",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{\(Sin[y]\), " ", 
                  StyleBox["j",
                    FontWeight->"Bold"]}]}], ")"}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((\(-2\), 3)\) . \)\)]],
  "\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{\(x\^2\), "y", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[ExponentialE]\^y\), "z", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{"x", " ", \(Sin[z]\), " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((2, 0, \[Pi])\)\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{\((x\^2 + y\^2)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"z", " ", \(Exp[x\ y]\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((0, \(-1\), 2)\)\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"x", " ", 
                  StyleBox["i",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{"y", " ", 
                  StyleBox["j",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{"z", " ", 
                  StyleBox["k",
                    FontWeight->"Bold"]}]}], ")"}], "/", 
            \(\@\(x\^2 + y\^2 + z\^2\)\)}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((\(-1\), 1, \(-1\))\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Sea  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " un campo escalar de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^2\)]],
  ". Calcula con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(div(grad\ f)\) \((x, y, z)\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Sea  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " un campo escalar y ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " un campo vectorial",
  ". Usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para comprobar la igualdad"
}], "ExerciseText"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"div", "(", 
          RowBox[{"f", " ", 
            StyleBox["F",
              FontWeight->"Bold"]}], ")"}], "=", 
        RowBox[{
          RowBox[{"f", " ", 
            RowBox[{"div", "(", 
              StyleBox["F",
                FontWeight->"Bold"], ")"}]}], "+", 
          RowBox[{"grad", " ", 
            RowBox[{"f", " ", 
              StyleBox[".",
                FontWeight->"Bold"], " ", 
              StyleBox["F",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[BoxData[{
    \(\(grad[f_]\)[x_, y_, z_] := 
      Module[{u, v, 
          w}, {D[f[u, v, w], u], D[f[u, v, w], v], 
            D[f[u, v, w], w]} /. {u -> x, v -> y, w -> z}]\), "\n", 
    \(\(div[Func_]\)[x_, y_, z_] := 
      Module[{u, v, 
          w}, \((D[\(Func[u, v, w]\)[\([1]\)], u] + 
              D[\(Func[u, v, w]\)[\([2]\)], v] + 
              D[\(Func[u, v, w]\)[\([3]\)], w])\) /. {u \[Rule] x, 
            v \[Rule] y, w \[Rule] z}]\)}], "Input"],

Cell[BoxData[
    \(\(div[grad[f]]\)[x, y, z]\)], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_, z_] = {F1[x, y, z], F2[x, y, z], F3[x, y, z]};\)\), "\n", 
    \(\(h[x_, y_, z_] = f[x, y, z]*F[x, y, z];\)\), "\n", 
    \(Simplify[\(div[h]\)[x, y, z] \[Equal] 
        f[x, y, z]*\ \(div[F]\)[x, y, z] + \(grad[f]\)[x, y, z] . 
            F[x, y, z]]\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rotacional de un campo vectorial", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Define comandos que calculen el rotacional de un campo vectorial de dos o \
de tres variables. La sintaxis del comando debe ser como sigue: \
rot[func][x,y] o rot[func][x,y,z] donde \"func\" es el nombre del campo \
vectorial (que debe ser una variable del comando). \nCalcula el rotacional de \
los siguientes campos vectoriales en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " que se indica en cada caso.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", 
          RowBox[{\(Exp[x]\), 
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(Cos[y]\), " ", 
                  StyleBox["i",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{\(Sin[y]\), " ", 
                  StyleBox["j",
                    FontWeight->"Bold"]}]}], ")"}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((\(-2\), 3)\) . \)\)]],
  "\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{\(x\^2\), "y", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[ExponentialE]\^y\), "z", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{"x", " ", \(Sin[z]\), " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((2, 0, \[Pi])\)\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{\((x\^2 + y\^2)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"z", " ", \(Exp[x\ y]\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((0, \(-1\), 2)\)\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"x", " ", 
                  StyleBox["i",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{"y", " ", 
                  StyleBox["j",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{"z", " ", 
                  StyleBox["k",
                    FontWeight->"Bold"]}]}], ")"}], "/", 
            \(\@\(x\^2 + y\^2 + z\^2\)\)}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((\(-1\), 1, \(-1\))\)\)]],
  ".\ne) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f \((x, y, z)\)\), "=", 
          RowBox[{
            RowBox[{"2", "x", " ", "y", " ", "z", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(x\^2\), "z", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(x\^2\), "y", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((x, y, z)\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Sea  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " un campo escalar y ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " un campo vectorial. Usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para comprobar la igualdad"
}], "ExerciseText"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"rot", "(", 
          RowBox[{"f", " ", 
            StyleBox["F",
              FontWeight->"Bold"]}], ")"}], "=", 
        RowBox[{
          RowBox[{"f", " ", 
            RowBox[{"rot", "(", 
              StyleBox["F",
                FontWeight->"Bold"], ")"}]}], "+", 
          RowBox[{"grad", " ", "f", "\[Times]", " ", 
            StyleBox["F",
              FontWeight->"Bold"]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " Usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para comprobar la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"div", "(", 
            RowBox[{"rot", " ", 
              StyleBox["F",
                FontWeight->"Bold"]}], ")"}], "=", "0"}], TraditionalForm]]],
  " v\[AAcute]lida para todo campo vectorial ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontWeight->"Bold"], TraditionalForm]]],
  " de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^2\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(\(rot[F_]\)[x_, y_, z_] := 
      Module[{u, v, 
          w}, {D[\(F[u, v, w]\)[\([3]\)], v] - D[\(F[u, v, w]\)[\([2]\)], w], 
            D[\(F[u, v, w]\)[\([1]\)], w] - D[\(F[u, v, w]\)[\([3]\)], u], 
            D[\(F[u, v, w]\)[\([2]\)], u] - 
              D[\(F[u, v, w]\)[\([1]\)], v]} /. {u -> x, v -> y, 
            w -> z}]\)], "Input"],

Cell[BoxData[
    \(Simplify[\(rot[h]\)[x, y, z] \[Equal] 
        f[x, y, z]*\ \(rot[F]\)[x, y, z] + 
          Cross[\(grad[f]\)[x, y, z], F[x, y, z]]]\)], "Input"],

Cell[BoxData[
    \(Simplify[\(div[rot[F]]\)[x, y, z]]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Laplaciano de un campo escalar", "Section"],

Cell[TextData[{
  "El ",
  StyleBox["laplaciano",
    FontWeight->"Bold"],
  " de un campo escalar ",
  StyleBox["f",
    FontSlant->"Italic"],
  " de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^2\)]],
  " es el campo escalar ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\ f\)]],
  " definido por"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        \(\[CapitalDelta]\ \(f(x, y, z)\) = 
          \(\[PartialD]\^2 f\/\[PartialD]x\^2\) \((x, y, z)\) + 
            \(\[PartialD]\^2 f\/\[PartialD]y\^2\) \((x, y, z)\) + 
            \(\[PartialD]\^2 f\/\[PartialD]z\^2\) \((x, y, z)\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si \[CapitalOmega] es un dominio en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", la ecuaci\[OAcute]n diferencial "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          \(\(\[PartialD]\^2 f\/\[PartialD]x\^2\) \((x, y, z)\) + 
            \(\[PartialD]\^2 f\/\[PartialD]y\^2\) \((x, y, z)\) + 
            \(\[PartialD]\^2 f\/\[PartialD]z\^2\) \((x, y, z)\)\),
          "TraditionalForm"], "=", 
        \(0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
            \((x, y, z)\) \[Element] \[CapitalOmega]\)}], TraditionalForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se llama ",
  StyleBox["ecuaci\[OAcute]n de Laplace",
    FontWeight->"Bold"],
  ". Las funciones ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  que satisfacen dicha ecuaci\[OAcute]n de llaman ",
  StyleBox["funciones arm\[OAcute]nicas",
    FontWeight->"Bold"],
  " en \[CapitalOmega]."
}], "Text"],

Cell["Es frecuente introducir el operador", "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"\[Del]", " ", 
              FormBox[
                RowBox[{"=", 
                  RowBox[{
                    RowBox[{\(\[PartialD]\/\[PartialD]x\), 
                      StyleBox["i",
                        FontWeight->"Bold"]}], "+"}]}],
                "TraditionalForm"]}], \(\[PartialD]\/\[PartialD]y\), 
            StyleBox["j",
              FontWeight->"Bold"]}], "+", 
          RowBox[{\(\[PartialD]\/\[PartialD]z\), 
            StyleBox["k",
              FontWeight->"Bold"]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Este operador, que suele llamarse con el extra\[NTilde]o nombre de \"nabla\
\", al actuar sobre un campo escalar ",
  StyleBox["f",
    FontSlant->"Italic"],
  " nos da su gradiente"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"\[Del]", " ", 
                  FormBox[
                    RowBox[{"f", "=", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(\[PartialD]\/\[PartialD]x\), 
                            StyleBox["i",
                              FontWeight->"Bold"]}], "+"}]}]}],
                    "TraditionalForm"]}], \(\[PartialD]\/\[PartialD]y\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(\[PartialD]\/\[PartialD]z\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}], 
            StyleBox[")",
              FontWeight->"Bold"]}], "f"}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\[PartialD]f\/\[PartialD]x\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]z\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}], "=", \(grad(f)\)}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si hacemos simb\[OAcute]licamente el producto escalar de \[Del] por un \
campo vectorial  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "=", \((F\_1, F\_2, F\_3)\)}], 
        TraditionalForm]]],
  " obtenemos la divergencia de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Del]", 
          RowBox[{
            StyleBox[".",
              FontWeight->"Bold"], "F"}]}], "=", 
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(\[PartialD]\/\[PartialD]x\), 
                    StyleBox["i",
                      FontWeight->"Bold"]}], "+", " ", 
                  RowBox[{\(\[PartialD]\/\[PartialD]y\), 
                    StyleBox["j",
                      FontWeight->"Bold"]}], "+", 
                  RowBox[{\(\[PartialD]\/\[PartialD]z\), 
                    StyleBox["k",
                      FontWeight->"Bold"]}]}], ")"}],
              "TraditionalForm"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            FormBox[
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(F\_1\), 
                    StyleBox["i",
                      FontWeight->"Bold"]}], "+", 
                  RowBox[{\(F\_2\), 
                    StyleBox["j",
                      FontWeight->"Bold"]}], "+", 
                  RowBox[{\(F\_3\), 
                    StyleBox["k",
                      FontWeight->"Bold"]}]}], ")"}],
              "TraditionalForm"]}], "=", 
          RowBox[{
          \(\[PartialD]F\_1\/\[PartialD]x + \[PartialD]F\_2\/\[PartialD]y + 
              \[PartialD]F\_3\/\[PartialD]z\), "=", 
            RowBox[{"div", "(", 
              StyleBox["F",
                FontWeight->"Bold"], ")"}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Por esa raz\[OAcute]n es frecuente representar la divergencia de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " por el s\[IAcute]mbolo ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Del]", 
          RowBox[{
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox["F",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". \nSi hacemos simb\[OAcute]licamente el producto escalar de \[Del] por s\
\[IAcute] mismo obtenemos el laplaciano:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"\[Del]", 
              RowBox[{
                StyleBox[".",
                  FontWeight->"Bold"], "\[Del]"}]}], ")"}], "f"}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\(\[PartialD]\/\[PartialD]x\), 
                      StyleBox["i",
                        FontWeight->"Bold"]}], "+", " ", 
                    RowBox[{\(\[PartialD]\/\[PartialD]y\), 
                      StyleBox["j",
                        FontWeight->"Bold"]}], "+", 
                    RowBox[{\(\[PartialD]\/\[PartialD]z\), 
                      StyleBox["k",
                        FontWeight->"Bold"]}]}], ")"}], 
                StyleBox[".",
                  FontWeight->"Bold"], 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\(\[PartialD]\/\[PartialD]x\), 
                      StyleBox["i",
                        FontWeight->"Bold"]}], "+", " ", 
                    RowBox[{\(\[PartialD]\/\[PartialD]y\), 
                      StyleBox["j",
                        FontWeight->"Bold"]}], "+", 
                    RowBox[{\(\[PartialD]\/\[PartialD]z\), 
                      StyleBox["k",
                        FontWeight->"Bold"]}]}], ")"}]}], ")"}], "f"}], "=", 
          RowBox[{
            
            FormBox[\(\[PartialD]\^2 f\/\[PartialD]x\^2 + 
                \[PartialD]\^2 f\/\[PartialD]y\^2 + 
                \[PartialD]\^2 f\/\[PartialD]z\^2\),
              "TraditionalForm"], "=", \(\[CapitalDelta]\ f\)}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Por esa raz\[OAcute]n es frecuente representar el laplaciano de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " por el s\[IAcute]mbolo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\^2 f\)]],
  ". \nSi hacemos simb\[OAcute]licamente el producto vectorial de \[Del] por \
un campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "=", \((F\_1, F\_2, F\_3)\)}], 
        TraditionalForm]]],
  " obtenemos el rotacional de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"\[Del]", 
                RowBox[{"\[Times]", 
                  StyleBox["F",
                    FontWeight->"Bold"], 
                  FormBox[
                    RowBox[{"=", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(\[PartialD]\/\[PartialD]x\), 
                            StyleBox["i",
                              FontWeight->"Bold"]}], "+"}]}]}],
                    "TraditionalForm"], \(\[PartialD]\/\[PartialD]y\), 
                  StyleBox["j",
                    FontWeight->"Bold"]}]}], "+", 
              RowBox[{\(\[PartialD]\/\[PartialD]z\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}], 
            StyleBox[")",
              FontWeight->"Bold"]}], "\[Times]", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{\(F\_1\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(F\_2\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(F\_3\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}], ")"}]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
            \((\[PartialD]F\_3\/\[PartialD]y - \[PartialD]F\_2\/\[PartialD]z)
                \), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
            \((\[PartialD]F\_1\/\[PartialD]z - \[PartialD]F\_3\/\[PartialD]x)
                \), 
              StyleBox["j",
                FontWeight->"Bold"]}], 
            StyleBox["+",
              FontWeight->"Bold"], 
            RowBox[{
            \((\[PartialD]F\_2\/\[PartialD]x - \[PartialD]F\_1\/\[PartialD]y)
                \), 
              StyleBox["k",
                FontWeight->"Bold"]}]}], 
          StyleBox[" ",
            FontWeight->"Bold"], "=", 
          RowBox[{"rot", "(", 
            StyleBox["F",
              FontWeight->"Bold"], ")"}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Las f\[OAcute]rmulas anteriores permiten recordar f\[AAcute]cilmente las \
definiciones de gradiente, divergencia, rotacional y laplaciano. \
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Define un comando que calcule el laplaciano de un campo escalar. La \
sintaxis de dicho comando debe ser de la forma \"laplaciano[func][x,y,z]\" \
donde \"func\" es el nombre de la funci\[OAcute]n que debe ser una variable \
del comando."
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " Sea  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "=", \((F\_1, F\_2, F\_3)\)}], 
        TraditionalForm]]],
  " un campo vectorial (de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^2\)]],
  "). Pongamos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{\(\[Del]\^2\), 
              StyleBox["F",
                FontWeight->"Bold"]}],
            "TraditionalForm"], "=", 
          RowBox[{"(", 
            RowBox[{
              FormBox[\(\[Del]\^2 F\_1\),
                "TraditionalForm"], ",", 
              FormBox[\(\[Del]\^2 F\_2\),
                "TraditionalForm"], ",", 
              FormBox[\(\[Del]\^2 F\_3\),
                "TraditionalForm"]}], ")"}]}], TraditionalForm]]],
  ". Usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para comprobar la igualdad:"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{"\[Del]", 
              RowBox[{"\[Times]", 
                RowBox[{"(", 
                  RowBox[{"\[Del]", 
                    RowBox[{"\[Times]", 
                      StyleBox["F",
                        FontWeight->"Bold"]}]}], ")"}]}]}], "=", 
            RowBox[{
              RowBox[{"\[Del]", 
                RowBox[{"(", 
                  RowBox[{"\[Del]", 
                    StyleBox[\( . F\),
                      FontWeight->"Bold"]}], ")"}]}], "-", 
              RowBox[{\(\[Del]\^2\), 
                StyleBox["F",
                  FontWeight->"Bold"]}]}]}],
          "TraditionalForm"], "                         "}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[BoxData[
    \(\(laplaciano[f_]\)[x_, y_, z_] := 
      Module[{u, v, 
          w}, \((D[f[u, v, w], {u, 2}] + D[f[u, v, w], {v, 2}] + 
              D[f[u, v, w], {w, 2}])\) /. {u -> x, v -> y, 
            w -> z}]\)], "Input"],

Cell[BoxData[
    \(Simplify[\(rot[rot[F]]\)[x, y, 
          z] == \(grad[div[F]]\)[x, y, z] - \(laplaciano[F]\)[x, y, 
            z]]\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, 2},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Gradiente, divergencia, rotacional, laplaciano."], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Gradiente, divergencia, rotacional, laplaciano."], 
        "Header"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 64, 0, 99, "Title"],
Cell[1821, 53, 189, 7, 130, "Author"],

Cell[CellGroupData[{
Cell[2035, 64, 39, 0, 93, "Section"],
Cell[2077, 66, 1781, 26, 351, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3895, 97, 48, 0, 93, "Section"],
Cell[3946, 99, 2979, 91, 313, "Text"],

Cell[CellGroupData[{
Cell[6950, 194, 31, 0, 68, "Exercise"],
Cell[6984, 196, 3734, 93, 587, "ExerciseText"],
Cell[10721, 291, 55, 1, 72, "Input"],
Cell[10779, 294, 303, 7, 115, "Input"],
Cell[11085, 303, 392, 7, 158, "Input"],
Cell[11480, 312, 154, 3, 127, "Input"],
Cell[11637, 317, 398, 8, 146, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12072, 330, 31, 0, 68, "Exercise"],
Cell[12106, 332, 193, 5, 41, "ExerciseText"],
Cell[12302, 339, 147, 3, 61, "Text"],
Cell[12452, 344, 1703, 30, 351, "ExerciseText"],
Cell[14158, 376, 1458, 27, 561, "Input"],
Cell[15619, 405, 76, 1, 72, "Input"],
Cell[15698, 408, 75, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15810, 414, 31, 0, 68, "Exercise"],
Cell[15844, 416, 193, 5, 41, "ExerciseText"],
Cell[16040, 423, 105, 2, 40, "Text"],
Cell[16148, 427, 900, 21, 179, "ExerciseText"],
Cell[17051, 450, 557, 11, 255, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17657, 467, 52, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[17734, 471, 31, 0, 68, "Exercise"],
Cell[17768, 473, 2653, 76, 263, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20458, 554, 31, 0, 68, "Exercise"],
Cell[20492, 556, 335, 14, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20864, 575, 31, 0, 68, "Exercise"],
Cell[20898, 577, 302, 13, 42, "ExerciseText"],
Cell[21203, 592, 609, 18, 35, "Text"],
Cell[21815, 612, 473, 10, 228, "Input"],
Cell[22291, 624, 58, 1, 72, "Input"],
Cell[22352, 627, 300, 5, 150, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22701, 638, 51, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[22777, 642, 31, 0, 68, "Exercise"],
Cell[22811, 644, 3201, 93, 297, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26049, 742, 31, 0, 68, "Exercise"],
Cell[26083, 744, 339, 14, 42, "ExerciseText"],
Cell[26425, 760, 523, 15, 35, "Text"],
Cell[26951, 777, 617, 23, 41, "ExerciseText"],
Cell[27571, 802, 368, 7, 176, "Input"],
Cell[27942, 811, 166, 3, 124, "Input"],
Cell[28111, 816, 67, 1, 72, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28227, 823, 49, 0, 93, "Section"],
Cell[28279, 825, 332, 14, 41, "Text"],
Cell[28614, 841, 365, 8, 65, "Text"],
Cell[28982, 851, 181, 5, 41, "Text"],
Cell[29166, 858, 480, 11, 65, "Text"],
Cell[29649, 871, 321, 11, 41, "Text"],
Cell[29973, 884, 51, 0, 41, "Text"],
Cell[30027, 886, 679, 19, 61, "Text"],
Cell[30709, 907, 213, 6, 41, "Text"],
Cell[30925, 915, 1314, 35, 62, "Text"],
Cell[32242, 952, 395, 14, 42, "Text"],
Cell[32640, 968, 1604, 43, 61, "Text"],
Cell[34247, 1013, 538, 16, 80, "Text"],
Cell[34788, 1031, 1766, 44, 65, "Text"],
Cell[36557, 1077, 599, 20, 80, "Text"],
Cell[37159, 1099, 2176, 60, 61, "Text"],
Cell[39338, 1161, 164, 3, 41, "Text"],

Cell[CellGroupData[{
Cell[39527, 1168, 31, 0, 68, "Exercise"],
Cell[39561, 1170, 320, 7, 67, "ExerciseText"],
Cell[39884, 1179, 986, 34, 67, "ExerciseText"],
Cell[40873, 1215, 806, 23, 40, "Text"],
Cell[41682, 1240, 235, 5, 172, "Input"],
Cell[41920, 1247, 149, 3, 94, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

